--[[---------------------------------------------------------------------------
	Chocolatier Two Options Dialog
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local xLeft = kCenter - ui.devButtonW/2
local xRight = kCenter + ui.devButtonW/2

MakeDialog
{
	Frame
	{
		x=kCenter,y=kCenter,w=400,h=245,color=DialogColor, fit=true,
		
		Options
		{
			x=0,y=0,w=kMax,h=kMax,fit=true,
			
			Text { x=5,y=25,w=390,h=20, label="opt_sfxlevel", flags=kVAlignTop+kHAlignCenter, },
			Text { x=5,y=60,w=390,h=20, label="opt_ambientlevel", flags=kVAlignTop+kHAlignCenter, },
			Text { x=5,y=95,w=390,h=20, label="opt_musiclevel", flags=kVAlignTop+kHAlignCenter, },
			
			SetStyle(sliderStyle),
			Slider { x=5,y=35,w=390,name="sfxslider", value=0 },
			Slider { x=5,y=70,w=390,name="ambientslider", value=0 },
			Slider { x=5,y=105,w=390,name="musicslider", value=0 },
			
			SetStyle(standardStyle),
			
			Button { x=140,y=130, name="fullscreen", type=kToggle, scale=.5, graphics=CheckButtonGraphics,
				command=function()
					if not ToggleFullScreen() then
						DisplayDialog { "ui/okdialog.lua", body ="opt_nofullscreen", }
					end
				end,
			},
			Text { x=172,y=132, w=kMax,h=32, label="opt_fullscreen", flags=kVAlignCenter+kHAlignLeft, },

			Button { x=140,y=160, name="mute", type=kToggle, scale=.5, graphics=CheckButtonGraphics,
				command = function() ToggleSoundMute() end },
			Text { x=172,y=162, w=kMax,h=32, label="opt_mute", flags=kVAlignCenter+kHAlignLeft, },

			TextButton { x=xLeft,y=200, label="ok", default=true,
				command = function() SaveVolumes() CloseWindow() end },
			TextButton { x=xRight,y=200, label="opt_credits", command = function() DoModal("ui/credits.lua") end },
		},
	}
}
